

--belegkopf aus Debitordaten anlegen
--
CREATE OR REPLACE FUNCTION tfaktura.belkopf__from_adk__create(krz VARCHAR, belart VARCHAR, txba INTEGER, manualbnr VARCHAR = NULL) RETURNS VARCHAR AS $$
    DECLARE bebnr VARCHAR;
            adk1waco RECORD;
    BEGIN
       /*wir holen uns die Adressdaten*/
       SELECT a1_krz INTO adk1waco FROM adressen_view JOIN adk1 ON adk_ad_krz=a1_krz JOIN bewa ON wa_einh=a1_waco WHERE ad_krz=krz;
       IF adk1waco.a1_krz IS NULL THEN--keine Debitordaten vorhanden
            RAISE EXCEPTION 'Keine Debitorendaten vorhanden xtt29790 %', krz;
       END IF;
       /**/
       IF manualbnr IS NOT NULL THEN
              bebnr:=manualbnr;
       ELSIF  krz='##' AND getnumcircleactive('BE_BNR_CASH') THEN
              bebnr:=getnumcirclenr('BE_BNR_CASH');--nextval('belkopf_be_bnr_kasse_seq');
       ELSIF (belart='P') AND getnumcircleactive('BE_BNR_P') THEN
              bebnr:=getnumcirclenr('BE_BNR_P');--nextval('belkopf_prof_be_bnr_seq');
       ELSIF (belart='T') AND getnumcircleactive('BE_BNR_A') THEN
              bebnr:=getnumcirclenr('BE_BNR_A');--nextval('belkopf_prof_be_bnr_seq');
       ELSIF (belart='G') AND getnumcircleactive('BE_BNR_G') THEN
              bebnr:=getnumcirclenr('BE_BNR_G');--nextval('belkopf_be_bnr_gut_seq');
       ELSE   --  R  --normale Rechnungskreise bzw Nummernkreis für Rechnugnstype nicht da -> normale Rechnungsnummernkreis
              bebnr:=getnumcirclenr('BE_BNR');--nextval('belkopf_be_bnr_seq')
       END IF;
       /**/
       INSERT INTO belkopf
                   (be_bnr, be_txba, be_rkrz, be_waco, be_spco,
                    be_sks, be_skv, be_zak,
                    be_wabk, be_umr, be_rund, be_prof,
                    be_steucode1, be_steuproz1,
                    be_vers, be_ktv_name, be_zahlart
                    )
             SELECT bebnr, txba, krz, a1_waco, a1_spco,
                    a1_sks, a1_skv, a1_zak,
                    wa_abkz, wa_kurs, wa_rund, belart,
                    steu_z, steu_proz,
                    a1_vers, a1_ktv_name, a1_zahlart
               FROM adk1
               JOIN bewa ON wa_einh = a1_waco
               CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get(a1_wuco)
               --LEFT JOIN steutxt ON steu_z = a1_wuco -- alte Version
              WHERE a1_krz = adk1waco.a1_krz;

       -- Bankkonto wohin Kunde überweisen soll
       UPDATE belkopf SET be_ktv_name = kto_name FROM ktovz WHERE be_bnr = bebnr AND be_ktv_name IS NULL AND kto_std;

       RETURN bebnr;
    END $$ LANGUAGE plpgsql;

-- Erstellt eine Gutschrift aus Rechnung oder Rechnung aus Proformarechnung (Unterscheidung nach Ausgangs-BE_PROF)
CREATE OR REPLACE FUNCTION tfaktura.CreateGutschriftFromRechnung(bnr VARCHAR) RETURNS VARCHAR AS $$
  BEGIN
    RETURN tfaktura.CreateGutschriftFromRechnung(NULL, bnr);
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION tfaktura.CreateGutschriftFromRechnung(manualbnr VARCHAR, bnr VARCHAR) RETURNS VARCHAR AS $$
  DECLARE newbebnr VARCHAR;
          krz VARCHAR;
          belart VARCHAR;         --Belegart aus der wir was Neues machen
          newbelart VARCHAR;      --Belegart, die wir neu machen
          rec RECORD;
          -- Kompatibilität altstruktur
          seqname_belabzu VARCHAR;
          seqname_belzeil VARCHAR;
          tablename_print_setting__copy VARCHAR;
          newbelegstruktur Boolean;
  BEGIN
    --
    IF (SELECT EXISTS (SELECT 1 FROM pg_catalog.pg_class c JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = 'public' AND c.relname = 'belkopf')) THEN --alte belegstruktur
          seqname_belabzu               := 'belabzu_beaz_id_seq';
          seqname_belzeil               := 'belzeil_bz_id_seq';
          tablename_print_setting__copy := 'belzeil_auftg_lif';
          newbelegstruktur              := False;
      ELSE
          seqname_belabzu               := 'tsystem_wawi.abzu_p_az_id_seq';
          seqname_belzeil               := 'tsystem_wawi.beleg_p_p_id_seq';
          tablename_print_setting__copy := 'rechnungv';
          newbelegstruktur              := True;
     END IF;
    --
    --Tmp-Tabellen nach Vorlage erstellen
    DROP TABLE IF EXISTS belkopftmp CASCADE;
    DROP TABLE IF EXISTS belzeil_txttmp CASCADE;
    DROP TABLE IF EXISTS belzeil_grundtmp CASCADE;
    DROP TABLE IF EXISTS belabzutmp CASCADE;
    DROP TABLE IF EXISTS belzeiltmp CASCADE;
    DROP TABLE IF EXISTS belzeilfreitmp CASCADE;
    DROP TABLE IF EXISTS belzeilauftgliftmp CASCADE;
    --
    CREATE TEMP TABLE belkopftmp (LIKE belkopf);
    IF newbelegstruktur THEN --belzeils
       CREATE TEMP TABLE belzeil_txttmp (LIKE belzeil_txt);
       CREATE TEMP TABLE belzeil_grundtmp (LIKE belzeil_grund);
      ELSE --alte struktur
       CREATE TEMP TABLE belzeiltmp (LIKE public.belzeil); --nur für Inherit
       CREATE TEMP TABLE belzeil_grundtmp (LIKE public.belzeil_grund) INHERITS(belzeiltmp);
       CREATE TEMP TABLE belzeil_freitmp () INHERITS(belzeil_grundtmp);
       CREATE TEMP TABLE belzeil_auftgliftmp () INHERITS(belzeil_grundtmp);
     END IF;
    CREATE TEMP TABLE belabzutmp (LIKE belabzu);
    --
    SELECT be_rkrz, be_prof /*, be_gutnr*/ INTO krz, belart /*, gutnr*/ FROM belkopf WHERE be_bnr = bnr;
    /*IF gutnr IS NOT NULL THEN
        RAISE EXCEPTION 'Gutschrift vorhanden: %', gutnr;
    END IF;*/
    --Neue Belegnummer holen

    -- Prüfen, was alter Beleg war und Nummerkreis vom Zielbelegtyp benutzen
    IF manualbnr IS NOT NULL THEN
        newbebnr := manualbnr;
    ELSIF (belart = 'P') AND getnumcircleactive('BE_BNR') THEN
        newbebnr := getnumcirclenr('BE_BNR');                     -- Wenn wir eine Proforma => richtige Rechnung machen, brauchen wir richtige Rechnungsnummer
    ELSIF (belart IN ('R', 'T')) AND getnumcircleactive('BE_BNR_G') THEN
        newbebnr := getnumcirclenr('BE_BNR_G');                   -- Gutschrift aus Rechnung => Gutschriften NumKreis.
    ELSE
        newbebnr := getnumcirclenr('BE_BNR');                     -- Kein Nummernkreis gefunden? Fallback auf Be_Bnr.
    END IF;

    --Rechnung => Gutschrift oder Proformarechnung zur Rechnung?
    IF belart IN ('R', 'T') THEN  newbelart := 'G';  END IF;
    IF belart = 'P' THEN  newbelart := 'R';  END IF;

    --Daten aus Rechnung uebernehmen
    INSERT INTO belkopftmp (SELECT * FROM belkopf WHERE be_bnr=bnr);
    -- belzeil
    IF newbelegstruktur THEN
       INSERT INTO belzeil_txttmp (SELECT * FROM /*ONLY*/ belzeil_txt WHERE bz_be_bnr=bnr);
       INSERT INTO belzeil_grundtmp (SELECT * FROM /*ONLY*/ belzeil_grund WHERE bz_be_bnr=bnr);
      ELSE
       -- Kompatibilität :alte Belkopf
       INSERT INTO belzeil_grundtmp (SELECT * FROM ONLY public.belzeil_grund WHERE bz_be_bnr=bnr);
       INSERT INTO belzeil_freitmp (SELECT * FROM ONLY public.belzeil_frei WHERE bz_be_bnr=bnr);
       INSERT INTO belzeil_auftgliftmp (SELECT * FROM ONLY public.belzeil_auftg_lif WHERE bz_be_bnr=bnr);
    END IF;
    --
    INSERT INTO belabzutmp (SELECT * FROM belabzu WHERE beaz_bebnr=bnr);
    --Updaten Belegnummer und be_prof
    UPDATE belkopftmp SET be_bnr=newbebnr, be_prof=newbelart, be_txba=IFTHEN(newbelart='G',2,1), dbrid=nextval('db_id_seq'), be_abprozent=IFTHEN(newbelart='G',NULL,be_abprozent), be_zahl_erledigt=FALSE, be_def=FALSE, be_bdat=now(), be_valuta=now(), be_buchdat=NULL;
    UPDATE belzeil_grundtmp SET bz_be_bnr=newbebnr, dbrid=nextval('db_id_seq'), bz_id=nextval(seqname_belzeil); -- bz_id neu vergeben, das ist sonst nicht mehr eindeutig (Fehlender primaryKey an von belzeil abgeleiteten Tabellen)
    IF newbelart = 'G' THEN
        -- 1. Gutschriften erhalten Info über originale Rechnungsposition; 2. verlieren Lieferscheinbezug
        UPDATE belzeil_grundtmp SET bz_bz_be_bnr=bnr, bz_bz_pos=bz_pos, bz_belp_id=NULL; -- bz_id neu vergeben, orig. RechPos, Lieferscheinbezug NULL
    END IF;
    UPDATE belabzutmp SET beaz_bebnr=newbebnr, beaz_id=nextval(seqname_belabzu), dbrid=nextval('db_id_seq');
    --

    --Zurueckschreiben
    INSERT INTO belkopf (SELECT * FROM belkopftmp);
    IF newbelegstruktur THEN
       UPDATE belzeil_txttmp SET p_k_id = NULL;
       UPDATE belzeil_grundtmp SET p_k_id = NULL;
       INSERT INTO belzeil_txt (SELECT * FROM belzeil_txttmp); --neue Struktur: alles ist in dieser Tablelle. Alte Struktur: nichts ist darin
       INSERT INTO belzeil_grund (SELECT * FROM belzeil_grundtmp); --neue Struktur: alles ist in dieser Tablelle. Alte Struktur: nichts ist darin
    ELSE
       INSERT INTO public.belzeil_grund (SELECT * FROM ONLY belzeil_grundtmp);
       INSERT INTO public.belzeil_frei (SELECT * FROM ONLY belzeil_freitmp);
       INSERT INTO public.belzeil_auftg_lif (SELECT * FROM ONLY belzeil_auftgliftmp);
    END IF;
    INSERT INTO belabzu (SELECT * FROM belabzutmp);

    -- auch PrintSetting 'psPriceMainPos' übernehmen
    IF newbelart = 'G' THEN
      FOR rec IN (SELECT belzeil_grund.bz_id AS src_id, belzeil_grundtmp.bz_id AS dest_id
                  FROM
                    belzeil_grund
                    LEFT JOIN belzeil_grundtmp ON belzeil_grundtmp.bz_be_bnr = newbebnr AND belzeil_grund.bz_pos = belzeil_grundtmp.bz_pos --AND --(bnr, newbebnr)
                  WHERE
                     belzeil_grund.bz_be_bnr = bnr) LOOP
        PERFORM TReporting.recnokeyword__print_setting__copy(tablename_print_setting__copy, rec.src_id, tablename_print_setting__copy, rec.dest_id);
      END LOOP;
    END IF;

    --Tmp-Tabellen droppen
    RETURN newbebnr;
  END $$ LANGUAGE plpgsql;
--

-- letzte Positionsnummer eines Lieferscheins ermitteln
CREATE OR REPLACE FUNCTION tfaktura.belzeillifmaxpos(VARCHAR) RETURNS INTEGER AS $$
    DECLARE bebnr ALIAS FOR $1;
            returnpos INTEGER;
    BEGIN
     returnpos:=max(bz_pos)+1 FROM belzeil_auftg_lif WHERE bz_be_bnr=bebnr;
     RETURN COALESCE(returnpos, 1);
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION tfaktura.belzeilfreimaxpos(VARCHAR) RETURNS INTEGER AS $$
    DECLARE bebnr ALIAS FOR $1;
            returnpos INTEGER;
    BEGIN
     returnpos:=max(bz_pos)+1 FROM belzeil_frei WHERE bz_be_bnr=bebnr;
     RETURN COALESCE(returnpos, 1);
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION tfaktura.belzeilmaxpos(VARCHAR) RETURNS INTEGER AS $$
    DECLARE bebnr ALIAS FOR $1;
            returnpos INTEGER;
    BEGIN
     returnpos:=max(bz_pos)+1 FROM belzeil WHERE bz_be_bnr=bebnr;
     RETURN COALESCE(returnpos, 1);
    END $$ LANGUAGE plpgsql;

--proformarechnung aus Auftragsdokument anlegen

-- Belegzeilen aus Auftragsposition generieren. Verwendet, wenn es keine Lagerbuchungen zum Auftrag gibt. Sonst belzeil__from_lifsch__create.
CREATE OR REPLACE FUNCTION tfaktura.belzeil__from_auftg__create(bebnr VARCHAR, auftgdoknr INTEGER, auftgzahlplanid INTEGER, agid INTEGER) RETURNS VOID AS $$
    DECLARE r RECORD;
    BEGIN
     PERFORM tfaktura.belzeil__from_auftg__create(bebnr, auftgdoknr, agid);
     If COALESCE(auftgzahlplanid,0)>0 THEN
            SELECT * INTO r FROM auftgdokzahlplan WHERE azp_id=auftgzahlplanid;
            IF COALESCE(r.azp_proz,0)>0 OR r.azp_bez IS NOT NULL THEN
                    UPDATE belkopf SET be_titel=COALESCE(be_titel, lang_belart(be_txba, prodat_languages.curr_lang()) ||' '|| r.azp_bez) WHERE be_bnr=bebnr;--Teilzahlungs/Abschlagsrechnung
                    UPDATE belkopf SET be_abprozent=COALESCE(be_abprozent, r.azp_proz) WHERE be_bnr=bebnr AND be_prof='T';--Teilzahlungs/Abschlagsrechnung
            END IF;
            UPDATE auftgdokzahlplan SET azp_be_bnr=bebnr WHERE azp_id=auftgzahlplanid AND azp_be_bnr IS NULL;--Eintragen der Belegnummer
     END IF;
     RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Rechnungszeile aus Auftrag
CREATE OR REPLACE FUNCTION tfaktura.belzeil__from_auftg__create(bebnr VARCHAR, auftgdokunr INTEGER, agid INTEGER ) RETURNS VOID AS $$ /*TWawi*/
 DECLARE recno Integer;
         auftgrec RECORD;
         belkopfr RECORD;
         belpos SMALLINT;
         belabzudbrids VARCHAR[];
         rab  NUMERIC;
         rabw NUMERIC;
         rabhint VARCHAR;
         grab  NUMERIC;
         bzzubez VARCHAR;
         bzzubez_rtf VARCHAR;
         steucodewarned BOOLEAN;
         bzid INTEGER;
 BEGIN
  --Steuersatz im Belegkopf
  SELECT be_umr, be_rkrz, be_waco, be_steucode1, be_steuproz1, be_steucode2, be_steuproz2 INTO belkopfr FROM belkopf WHERE be_bnr=bebnr;

  recno := 0; --MF letzte Belegzeilenpos rauskramen
  steucodewarned := FALSE;
  FOR auftgrec IN SELECT auftg.*, coalesce(ag_konto, ak_zeko) AS ak_zeko,
                         steu_z, steu_proz,
                         auftgdokutxt.atd_zak, auftgdokutxt.atd_skv, auftgdokutxt.atd_sks, auftgdokutxt.atd_vers, auftgdokutxt.atd_gesrab,
                         -- #7715
                         (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txt    AS ak_faktxt,
                         (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txtrtf AS ak_faktxt_rtf

                    FROM auftg
                    JOIN auftgdokutxt ON atd_dokunr=ag_dokunr
                    JOIN art ON ag_aknr = ak_nr
                    CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get(ag_steucode)
                    --LEFT JOIN steutxt ON steu_z = ag_steucode -- alte Version
                   WHERE ag_dokunr = auftgdokunr AND NOT ag_storno AND ag_id = coalesce(agid,ag_id) --Wenn agid angegeben, dann nur die einer Position bitte.
                   ORDER BY ag_nr, ag_pos
  LOOP
        --
        IF recno = 0 THEN--erste Position, Bezahldaten aus Auftragskopf?
               UPDATE belkopf SET
                      be_sks = coalesce(auftgrec.atd_sks, be_sks),
                      be_skv = coalesce(auftgrec.atd_skv, be_skv),
                      be_zak = coalesce(auftgrec.atd_zak, be_zak),
                      be_vers = coalesce(auftgrec.atd_vers, be_vers),
                      be_liefkrz = coalesce(be_liefkrz, auftgrec.ag_krzl),
                      be_waco = auftgrec.ag_waer,
                      be_wabk = wa_abkz,
                      be_umr = wa_kurs,
                      be_steucode2 = IFTHEN(auftgrec.steu_z IS DISTINCT FROM be_steucode1, auftgrec.steu_z, be_steucode2), --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
                      be_steuproz2 = IFTHEN(auftgrec.steu_proz IS DISTINCT FROM be_steuproz1, auftgrec.steu_proz, be_steuproz2) --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
                 FROM bewa
                WHERE wa_einh = auftgrec.ag_waer
                  AND be_bnr = bebnr
            RETURNING be_steucode2, be_steuproz2
                 INTO belkopfr.be_steucode2, belkopfr.be_steuproz2
                ;
        END IF;
        recno := 1;
        --Pos.Rabatte nur übernehmen wenn Artikel Rabattfähig
        IF auftgrec.ag_canRabatt THEN
                rab := auftgrec.ag_arab;
                IF auftgrec.ag_rabhint = lang_text(21333) OR auftgrec.ag_rabhint IS NULL then --währungsrabatt aktualisieren, Außer es ist irgendein Sonderrabtt drin mit Text
                        rabw := adwarab_rab FROM adkbewarab JOIN bewa ON wa_einh=auftgrec.ag_waer
                                           WHERE adwarab_ad_krz=auftgrec.ag_krzf AND adwarab_waco=auftgrec.ag_waer
                                             AND wa_kurs BETWEEN adwarab_kurs_ab AND adwarab_kurs_bis AND coalesce(adwarab_auslauf, current_date)>=current_date
                                           ORDER BY adwarab_auslauf, adwarab_ad_krz=auftgrec.ag_krzf
                                           NULLS LAST;
                        IF rabw IS NOT NULL THEN
                            rab := rabw;
                            rabhint := lang_text(21333);
                        END IF;
                END IF;
                grab := auftgrec.atd_gesrab;
        ELSE
                rab  := 0; -- Wird normalerweise bei Posten Auftg = 0 gesetzt, hier nur Sicherheitshalber nochmal
                grab := 0;
        END IF;
      -- In Rechnung soll immer Text aus Artikelstamm genommen werden #8296
        IF TSystem.Settings__GetBool('bzUseArtTxt') THEN
            bzzubez     := auftgrec.ak_faktxt;
            bzzubez_rtf := auftgrec.ak_faktxt_rtf;
        ELSE
          -- Je nach Setting entweder zuerst immer Auftragspositionstext oder Fakturatext aus Artikelstamm nehmen.
          IF (TSystem.Settings__GetBool('bzUseAuftTxt')) THEN
            bzzubez    :=coalesce(auftgrec.ag_txt,auftgrec.ak_faktxt );
            bzzubez_rtf:=coalesce(auftgrec.ag_txt_rtf, auftgrec.ak_faktxt_rtf);
          ELSE
            bzzubez    :=coalesce(auftgrec.ak_faktxt,auftgrec.ag_txt);
            bzzubez_rtf:=coalesce(auftgrec.ak_faktxt_rtf,auftgrec.ag_txt_rtf);
          END IF;
        END IF;

        -- Warnung, wenn Steuercode aus Auftragsposition nicht Steuercode aus Rechnungskopf enspricht
        IF auftgrec.ag_steucode NOT IN (belkopfr.be_steucode1,  belkopfr.be_steucode2) AND (NOT steucodewarned) THEN
            PERFORM PRODAT_HINT(langtext(12761));
            steucodewarned:=TRUE;
        END IF;

        belpos := tfaktura.belzeilmaxpos(bebnr);
        INSERT INTO belzeil_auftg_lif
                    (bz_be_bnr, bz_pos, bz_hwpos, bz_aknr, bz_akbz, bz_ks, bz_zeko,
                     bz_mce, bz_mcbez, bz_vkp_mce, bz_zubez, bz_zubez_rtf, bz_fakt,
                     bz_steucode, bz_steuproz,
                     bz_auftg, bz_auftgpos, bz_auftghpos, bz_preis, bz_preiseinheit, bz_vkp, bz_vkpbas, bz_vkptotalpos, bz_arab, bz_rabhint,
                     bz_gesrab, bz_canrabatt, bz_an_nr, bz_bda
                     )
             SELECT bebnr, belpos, auftgrec.ag_hwpos, auftgrec.ag_aknr, auftgrec.ag_akbz, auftgrec.ag_ks, auftgrec.ak_zeko,
                     auftgrec.ag_mcv, lang_artmgc_id(auftgrec.ag_mcv, prodat_languages.customerlang(auftgrec.ag_krzf)),
                     auftgrec.ag_vkp_mce, bzzubez, bzzubez_rtf,  tartikel.me__menge_uf1__in__menge(auftgrec.ag_mcv, auftgrec.ag_stk_uf1-auftgrec.ag_stkf),
                     coalesce(auftgrec.steu_z, belkopfr.be_steucode1), coalesce(auftgrec.steu_proz, belkopfr.be_steuproz1, 0),
                     auftgrec.ag_nr, auftgrec.ag_pos, auftgrec.ag_hpos, auftgrec.ag_preis, auftgrec.ag_preiseinheit,
                     auftgrec.ag_vkp, auftgrec.ag_vkpbas, auftgrec.ag_vkptotalpos, coalesce(rab,0), coalesce(auftgrec.ag_rabhint, rabhint), coalesce(grab,0), auftgrec.ag_canrabatt,
                     auftgrec.ag_an_nr, coalesce( auftgrec.ag_bda,'') ||  coalesce( ' / ' || auftgrec.ag_bdapos,'')
        RETURNING bz_id INTO bzid;

        -- auch PrintSetting 'psPriceMainPos' übernehmen
        PERFORM TReporting.recnokeyword__print_setting__copy('auftg', auftgrec.ag_id, 'belzeil_auftg_lif', bzid);

        UPDATE auftg SET ag_done = TRUE WHERE ag_id = auftgrec.ag_id AND Round(ag_stk_uf1,4)=Round(ag_stkf,4);

        --abzuschläge aus Auftrag holen
        SELECT TWawi.Abzu_Copy('Auftg_Abzu', auftgrec.ag_id::VARCHAR, 'BelKopf_Abzu', bebnr, tartikel.me__menge_uf1__in__menge(auftgrec.ag_mcv, auftgrec.ag_stk_uf1-auftgrec.ag_stkf)) INTO belabzudbrids;
        -- Daten nachtragen, die nicht von Abzu_Copy übernommen wurden, da nicht im View-Standard enthalten. Verknüpfung mit Auftrag.
        UPDATE belabzu SET beaz_agnr = auftgrec.ag_nr, beaz_agpos = auftgrec.ag_pos, beaz_belpos = belpos
          WHERE belabzu.dbrid = ANY(belabzudbrids);

  END LOOP;
  RETURN;
 END $$ LANGUAGE plpgsql;
--


-- Belegzeilen aus Lagerabgängen (und Auftragsposition) generieren.
CREATE OR REPLACE FUNCTION tfaktura.belzeil__from_lifsch__create(bebnr VARCHAR, lifschdokunr VARCHAR, belpid INTEGER, lifschmenge NUMERIC DEFAULT NULL) RETURNS VOID AS /*TWawi*/$$
 DECLARE lifschauftg RECORD;
         belkopfr RECORD;
         tmpr RECORD;
         rab  NUMERIC;
         rabw NUMERIC;
         rabhint VARCHAR;
         belpos SMALLINT;
         belabzudbrids VARCHAR[];
         grab NUMERIC;
         faktmenge NUMERIC;
         vkpvkp  NUMERIC;
         bzzubez VARCHAR;
         bzzubez_rtf VARCHAR;
         akbz VARCHAR;
         steucodewarned BOOLEAN;
         bzid INTEGER;
         bem1_txt TEXT;
         bem2_txt TEXT;
         bem1_txt_rtf TEXT;
         bem2_txt_rtf TEXT;
 BEGIN
  --- #8083; die Mengenangabe ist nur zulässig, wenn auch eine belp_id mitgegeben wird, sonst Exception.
  IF lifschmenge IS NOT NULL AND COALESCE(belpid, 0) = 0 THEN
     RAISE EXCEPTION '%', langtext(29117);  -- Teilmenge kann nicht übernommen werden, weil kein Bezug zum Lieferschein vorhanden ist.
  END IF;
  ---
  SELECT be_umr, be_rkrz, be_waco, be_steucode1, be_steuproz1, be_steucode2, be_steuproz2 INTO belkopfr FROM belkopf WHERE be_bnr=bebnr;
  steucodewarned := False;
  --wir holen uns die Daten aus Lieferschein und Auftrag
  FOR lifschauftg IN SELECT belegdokument.*, belegpos.*, auftg.*, ak_vkpbas, coalesce(ag_konto, ak_zeko) AS ak_zeko,
                            steu_z, steu_proz,
                            auftgdokutxt.atd_zak, auftgdokutxt.atd_skv, auftgdokutxt.atd_sks, auftgdokutxt.atd_vers, auftgdokutxt.atd_gesrab,
                            auftgdokutxt.atd_txt, auftgdokutxt.atd_txt_rtf, auftgdokutxt.atd_txt1, auftgdokutxt.atd_txt1_rtf, belkopfr.be_rkrz AS krz,
                            -- #7715
                            (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txt    AS ak_faktxt,
                            (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txtrtf AS ak_faktxt_rtf,

                            ag_txt, belp_dokutxt, ag_txt_rtf, belp_dokutxt_rtf
                       FROM belegpos
                       JOIN belegdokument ON belp_dokument_id = beld_id
                       LEFT JOIN auftg ON belp_ag_id = ag_id
                       LEFT JOIN art   ON belp_aknr  = ak_nr
                       LEFT JOIN auftgdokutxt ON atd_dokunr = ag_dokunr
                       CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get(ag_steucode)
                       -- LEFT JOIN steutxt ON steu_z = ag_steucode -- alte Version

                      WHERE beld_belegtyp = 'LFS'
                        AND beld_dokunr = lifschdokunr
                        AND (NOT belp_erledigt)
                        AND (NOT belp_storniert)  --(Erledigt = Schon verrechnet, Storniert = Nicht verrechenbar)
                        AND belp_id = coalesce(belpid,belp_id) -- Nur die eine Belegposition wenn angegeben
                      ORDER BY belp_pos
  LOOP

       belpos := tfaktura.belzeilmaxpos(bebnr);
       --
       IF belpos = 1 THEN--erste Position, Bezahldaten aus Auftragskopf?
            --in Belegkopf die Daten (Anschreiben und Schlußtext) aus Auftrag/Lieferschein eintragen
            UPDATE belkopf SET
                   be_sks = coalesce(lifschauftg.atd_sks, be_sks),
                   be_skv = coalesce(lifschauftg.atd_skv, be_skv),
                   be_zak = coalesce(lifschauftg.atd_zak, be_zak),

                   -- #20032 Versandart vorzugsweise aus dem Belegkopf oder alternativ aus der ersten Position nehmen
                   be_vers = coalesce( CAST(lifschauftg.beld_versandartbem AS varchar(50)), CAST(lifschauftg.belp_versandartbem AS varchar(50)), be_vers ),
                   -- be_gew = coalesce( lifschauftg.beld_gewicht, lifschauftg.belp_gewicht, be_gew ), -- auskommentiert siehe https://redmine.prodat-sql.de/issues/20285#note-6 https://ci.prodat-sql.de/sources/tests/suite/15/runner/1164#teststep-18347

                   be_liefkrz = coalesce(be_liefkrz, lifschauftg.belp_krzlieferung, lifschauftg.beld_krzlieferung),
                   be_waco = lifschauftg.ag_waer,
                   be_wabk = wa_abkz,
                   be_umr = wa_kurs,
                   be_steucode2 = IFTHEN(lifschauftg.steu_z IS DISTINCT FROM be_steucode1, lifschauftg.steu_z, be_steucode2), --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
                   be_steuproz2 = IFTHEN(lifschauftg.steu_proz IS DISTINCT FROM be_steuproz1, lifschauftg.steu_proz, be_steuproz2) --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
              FROM bewa
             WHERE wa_einh = lifschauftg.ag_waer
               AND be_bnr = bebnr
            RETURNING be_steucode2, be_steuproz2 INTO belkopfr.be_steucode2, belkopfr.be_steuproz2
            ;

            -- freier Lieferschein
            IF lifschauftg.ag_id IS NULL THEN
                UPDATE belkopf SET
                       be_liefkrz = coalesce( be_liefkrz, lifschauftg.belp_krzlieferung, lifschauftg.beld_krzlieferung ),
                       be_vers    = coalesce( CAST(lifschauftg.beld_versandartbem AS varchar(50)), CAST(lifschauftg.belp_versandartbem AS varchar(50)), be_vers )
                 WHERE be_bnr = bebnr
                ;
            END IF;

            /*   #10669
            'belkopf_dont_use_lifschtxt' = :
               TRUE  -> Auftragstext prüfen, wenn vorhanden übernehmen, sonst Faktura - Vorgabetext Bemerkungsverwaltung lassen
               FALSE -> Lieferscheintext prüfen,wenn vorhanden übernehmen, sonst Faktura - Vorgabetext Bemerkungsverwaltung lassen
               LG: Dringender Fix, Spektra will immer den Bemerkungsverwaltungstext und nie die aus Auftrag oder Lieferschein. Wird
                   mit Folgeticket nach Überarbeitung entfernt.
                 #12291
               belkopf__b_i > es sind hier bereits die Texte der Bemerkungsverwaltung vorhanden!
            */
            IF NOT TSystem.Settings__GetBool('belkopf__belarzu__always__bemerkungsverwaltung')
            THEN
              IF TSystem.Settings__GetBool('belkopf_dont_use_lifschtxt') THEN -- Auftragstext übernehmen wenn Texte nicht leer sind
                 IF (lifschauftg.atd_txt IS NOT NULL) AND (lifschauftg.atd_txt <> '') THEN
                    bem1_txt = lifschauftg.atd_txt;
                    bem1_txt_rtf = lifschauftg.atd_txt_rtf;
                 ELSE
                    SELECT txt, txtrtf INTO bem1_txt, bem1_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_KOPF', prodat_languages.adk1_spco(lifschauftg.krz));
               END IF;
               IF (lifschauftg.atd_txt1 IS NOT NULL) AND (lifschauftg.atd_txt1 <> '') THEN
                    bem2_txt = lifschauftg.atd_txt1;
                    bem2_txt_rtf = lifschauftg.atd_txt1_rtf;
                 ELSE
                    SELECT txt, txtrtf INTO bem2_txt, bem2_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_FUSS', prodat_languages.adk1_spco(lifschauftg.krz));
               END IF;
            ELSE                    -- Lieferscheintext übernehmen wenn Texte nicht leer sind
               IF (lifschauftg.beld_kopftext IS NOT NULL) AND (lifschauftg.beld_kopftext <> '') THEN
                  bem1_txt = lifschauftg.beld_kopftext;
                  bem1_txt_rtf = lifschauftg.beld_kopftext_rtf;
               ELSE
                    SELECT txt, txtrtf INTO bem1_txt, bem1_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_KOPF', prodat_languages.adk1_spco(lifschauftg.krz));
               END IF;

               IF (lifschauftg.beld_fusstext IS NOT NULL) AND (lifschauftg.beld_fusstext <> '') THEN
                  bem2_txt = lifschauftg.beld_fusstext;
                  bem2_txt_rtf = lifschauftg.beld_fusstext_rtf;
               ELSE
                    SELECT txt, txtrtf INTO bem2_txt, bem2_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_FUSS', prodat_languages.adk1_spco(lifschauftg.krz));
                 END IF;
              END IF;

              UPDATE belkopf
                 SET be_bem1 = bem1_txt,
                     be_bem2 = bem2_txt,
                     be_bem1_rtf = bem1_txt_rtf,
                     be_bem2_rtf = bem2_txt_rtf
               WHERE be_bnr = bebnr;
            END IF;
       END IF;

       --Pos.Rabatte nur übernehmen wenn Artikel Rabattfähig
       IF lifschauftg.ag_canRabatt THEN
            rab := lifschauftg.ag_arab;
            -- Währungsrabatt > Drop, nicht mehr in Benutzung? (Grob)
            IF lifschauftg.ag_rabhint=lang_text(21333) OR lifschauftg.ag_rabhint IS NULL then --währungsrabatt aktualisieren
               rabw := adwarab_rab FROM adkbewarab
                                   JOIN bewa ON wa_einh = lifschauftg.ag_waer
                                  WHERE (adwarab_ad_krz = lifschauftg.ag_krzf OR adwarab_ad_vpber=lifschauftg.ag_kukl)
                                    AND adwarab_waco=lifschauftg.ag_waer
                                    AND wa_kurs BETWEEN adwarab_kurs_ab AND adwarab_kurs_bis AND coalesce(adwarab_auslauf, current_date) >= current_date
                                  ORDER BY adwarab_auslauf, adwarab_ad_krz=lifschauftg.ag_krzf NULLS LAST
               ;

               IF rabw IS NOT NULL THEN
                   rab := rabw;
                   rabhint := lang_text(21333);
               END IF;
            END IF;
            grab := lifschauftg.atd_gesrab;
       ELSE
            rab  := 0; -- Wird normalerweise bei Posten Auftg = 0 gesetzt, hier nur Sicherheitshalber nochmal
            grab := 0;
       END IF;
       -- In Rechnung soll immer Text aus Artikelstamm genommen werden #8296
       IF TSystem.Settings__GetBool('bzUseArtTxt') THEN
           bzzubez     := lifschauftg.ak_faktxt;
           bzzubez_rtf := lifschauftg.ak_faktxt_rtf;
       ELSE
           -- Je nach Setting entweder zuerst immer Auftragspositionstext oder Fakturatext aus Artikelstamm nehmen.
           IF (TSystem.Settings__GetBool('bzUseAuftTxt')) THEN
               bzzubez    :=coalesce(lifschauftg.ag_txt,     lifschauftg.ak_faktxt,     lifschauftg.belp_dokutxt);
               bzzubez_rtf:=coalesce(lifschauftg.ag_txt_rtf, lifschauftg.ak_faktxt_rtf, lifschauftg.belp_dokutxt_rtf);
           ELSE
               bzzubez    :=coalesce(lifschauftg.ak_faktxt,     lifschauftg.belp_dokutxt,     lifschauftg.ag_txt);
               bzzubez_rtf:=coalesce(lifschauftg.ak_faktxt_rtf, lifschauftg.belp_dokutxt_rtf, lifschauftg.ag_txt_rtf);
           END IF;
       END IF;
       -- Artikelbezeichnung vorzugsweise aus Auftrag
       IF (TSystem.Settings__GetBool('bzUseAuftTxt')) THEN
            akbz := coalesce(lifschauftg.ag_akbz, lifschauftg.belp_akbez);
       ELSE
            akbz := lifschauftg.belp_akbez;
       END IF;
       -- Warnung, wenn Steuercode aus Auftragsposition nicht Steuercode aus Rechnungskopf enspricht
       IF lifschauftg.ag_steucode NOT IN (belkopfr.be_steucode1,  belkopfr.be_steucode2) AND (NOT steucodewarned) THEN
            PERFORM PRODAT_HINT(langtext(12761));
            steucodewarned := TRUE;
       END IF;

       faktmenge := tartikel.me__menge_uf1__in__menge(lifschauftg.belp_mce, lifschauftg.belp_menge_gme-lifschauftg.belp_menge_done_gme);

       --- #8033
       IF (lifschmenge IS NOT NULL) AND (lifschauftg.beld_belegtyp = 'LFS') THEN
           IF (lifschmenge <= faktmenge) THEN
              faktmenge := lifschmenge;
           ELSE
              RAISE EXCEPTION '% %', langtext(29116), faktmenge::NUMERIC(12,4);    -- 'Teilmenge ist größer als offene Menge. Zulässige Menge ist maximal:'
           END IF;
       END IF;
       -- freier Lieferschein, Preis laden!
       IF lifschauftg.ag_id IS NULL THEN
           SELECT * INTO tmpr FROM artikel_vkppreis(lifschauftg.belp_aknr, belkopfr.be_rkrz, NULL, faktmenge, belkopfr.be_waco, belkopfr.be_umr, lifschauftg.belp_menge / Do1If0(lifschauftg.belp_menge_gme));
           vkpvkp := tmpr.vkp;
           rab    := tmpr.rab;
       END IF;
       --
       INSERT INTO belzeil_auftg_lif
               (bz_be_bnr, bz_pos, bz_aknr, bz_akbz, bz_mce, bz_vkp_mce, bz_fakt,
                bz_steucode, bz_steuproz,
                bz_auftg, bz_auftgpos, bz_preis, bz_preiseinheit, /*bz_vkp,*/  bz_vkpbas,
                bz_arab, bz_rabhint, bz_gesrab, bz_canrabatt,
                bz_zubez, bz_zubez_rtf, bz_an_nr, bz_ks, bz_zeko, bz_belp_id, bz_bda,
                bz_hwpos, bz_auftghpos, bz_vkptotalpos
                )
        VALUES (bebnr, belpos, lifschauftg.belp_aknr, akbz, lifschauftg.belp_mce, lifschauftg.ag_vkp_mce, faktmenge,
                coalesce(lifschauftg.steu_z, belkopfr.be_steucode1), coalesce(lifschauftg.steu_proz, belkopfr.be_steuproz1, 0),
                lifschauftg.ag_nr, lifschauftg.ag_pos,
                coalesce(lifschauftg.ag_preis,vkpvkp), lifschauftg.ag_preiseinheit, /*vkpvkp,*/ coalesce(lifschauftg.ag_vkpbas, lifschauftg.ak_vkpbas),
                coalesce(rab, 0), coalesce(lifschauftg.ag_rabhint, rabhint), coalesce(grab, 0), coalesce(lifschauftg.ag_canrabatt, TRUE),
                bzzubez, bzzubez_rtf, lifschauftg.belp_projektnummer, lifschauftg.ag_ks, lifschauftg.ak_zeko, lifschauftg.belp_id, lifschauftg.belp_referenz,
                lifschauftg.ag_hwpos, lifschauftg.ag_hpos, coalesce(lifschauftg.ag_vkptotalpos, FALSE)
                )
      RETURNING bz_id
           INTO bzid;

       -- auch PrintSetting 'psPriceMainPos' übernehmen
       PERFORM TReporting.recnokeyword__print_setting__copy('belegpos', lifschauftg.belp_id, 'belzeil_auftg_lif', bzid);

       -- Abzuschläge aus Auftrag holen
       SELECT TWawi.Abzu_Copy('Auftg_Abzu', lifschauftg.ag_id::VARCHAR, 'BelKopf_Abzu', bebnr, faktmenge) INTO belabzudbrids;
       -- Daten nachtragen, die nicht von Abzu_Copy übernommen wurden, da nicht im View-Standard enthalten. Verknüpfung mit Auftrag.
       UPDATE belabzu
          SET beaz_agnr = lifschauftg.ag_nr, beaz_agpos = lifschauftg.ag_pos, beaz_belpos = belpos
        WHERE belabzu.dbrid = ANY(belabzudbrids);

       -- Apint aus Zutänder MA Auftrag nehmen, wenn automatische Auslieferung
       IF EXISTS(SELECT TRUE FROM lifsch WHERE l_nr = lifschdokunr AND l_lgort = 'ALAUTO') THEN
          UPDATE belkopf
             SET be_apint = coalesce(lifschauftg.ag_kontakt, current_user)
           WHERE be_bnr = bebnr;
       END IF;
       --
  END LOOP;
  RETURN;
 END $$ LANGUAGE plpgsql;

/*lösche in 2019/08
 CREATE OR REPLACE FUNCTION tfaktura.createbelzeilfromlifsch(bebnr VARCHAR, lifschdokunr VARCHAR, belpid INTEGER, lifschmenge NUMERIC DEFAULT NULL) RETURNS VOID AS $$
  BEGIN
   PERFORM tfaktura.belzeil__from_lifsch__create(bebnr, lifschdokunr, belpid, lifschmenge);
   RETURN;
  END $$ LANGUAGE plpgsql;
*/
--

--Projektnummer aus auftg holen
CREATE OR REPLACE FUNCTION tfaktura.get_belzeil_projektnr(VARCHAR) RETURNS VARCHAR AS $$
    DECLARE bebnr ALIAS FOR $1;
            agnr VARCHAR;
            agpos VARCHAR;
    BEGIN
     SELECT bz_auftg, bz_auftgpos INTO agnr, agpos FROM belzeil_auftg_lif WHERE bz_be_bnr=bebnr ORDER BY bz_pos LIMIT 1;
     RETURN ag_an_nr FROM auftg WHERE ag_astat='E' AND ag_nr=agnr AND ag_pos=agpos;
    END $$ LANGUAGE plpgsql VOLATILE;


--Belegzeile aus FEMI-Lieferschein (NEU)
CREATE OR REPLACE FUNCTION tfaktura.belzeil__from_femilifsch__create(bebnr VARCHAR, lifschdokunr VARCHAR) RETURNS VOID AS $$
    DECLARE lifschPos1  RECORD;
            wuco INTEGER;
            proz NUMERIC;
            su   NUMERIC;
            bzzubez VARCHAR;
            bzzubez_rtf VARCHAR;
    BEGIN
     --Anmerkung: Erzeugt eine einzige Belegzeile aus allen Positionen eines Femi-Lieferscheins
     --           Da wahllos Lieferscheinpositionen zusammengezogen werden, werden Preiseinheiten hier nicht unterstützt.
     SELECT be_steucode1, be_steuproz1 INTO wuco, proz FROM belkopf WHERE be_bnr=bebnr;

     --Erste Position aus Lieferschein/Auftrag holen
     SELECT *,
       -- #7715
      (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', beld_krzbesteller)).txt    AS ak_faktxt,
      (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', beld_krzbesteller)).txtrtf AS ak_faktxt_rtf
     INTO lifschPos1 FROM belegpos LEFT JOIN auftg ON belp_ag_id = ag_id
                                            LEFT JOIN art ON belp_aknr = ak_nr
                                            LEFT JOIN belegdokument ON belp_dokument_id = beld_id
                              WHERE beld_belegtyp = 'LFS' AND beld_dokunr = lifschdokunr AND NOT beld_verbucht  -- War mal l_abgg_uf1-l_fakt>0 statt beld_verbucht für alten Lieferschein
                              ORDER BY belp_pos LIMIT 1;

     su:=0;
     -- In Rechnung soll immer Text aus Artikelstamm genommen werden #8296
     IF TSystem.Settings__GetBool('bzUseArtTxt') THEN
       bzzubez    := lifschPos1.ak_faktxt;
       bzzubez_rtf:= lifschPos1.ak_faktxt_rtf;
     ELSE
       bzzubez     := lifschpos1.belp_dokutxt;
       bzzubez_rtf := lifschpos1.belp_dokutxt_rtf;
     END IF;

     --wir holen uns die Daten aus Lieferschein und Auftrag
     SELECT Sum(ag_vkp) INTO su FROM auftg
                            JOIN belegpos ON belp_ag_id = ag_id
                            JOIN belegdokument ON belp_dokument_id = beld_id
                            WHERE beld_belegtyp = 'LFS' AND beld_dokunr=lifschdokunr AND NOT beld_verbucht;

     INSERT INTO belzeil_auftg_lif (bz_be_bnr, bz_pos, bz_aknr, bz_mce, bz_fakt, bz_steucode, bz_steuproz,
                                    bz_belp_id, bz_auftg, bz_auftgpos,
                                    bz_vkp, bz_vkpbas,
                                    bz_arab, bz_hwpos,
                                    bz_zubez, bz_zubez_rtf,bz_an_nr)
            SELECT  bebnr, tfaktura.belzeilmaxpos(bebnr), lifschPos1.belp_aknr, lifschPos1.belp_mce,
                    tartikel.me__menge_uf1__in__menge(lifschPos1.belp_mce, lifschPos1.belp_menge_gme - lifschPos1.belp_menge_done_gme), -- War mal lifschPos1.l_abgg_uf1-lifschPos1.l_fakt),
                    wuco, COALESCE(proz, lifschPos1.ag_ustpr, 0), lifschPos1.belp_id, lifschPos1.ag_nr, lifschPos1.ag_pos,
                    su,su,
                    0 , lifschPos1.ag_hwpos,
                    bzzubez, bzzubez_rtf, lifschpos1.belp_projektnummer; --War mal lifschPos1.l_azutx, lifschPos1.l_azutx_rtf, lifschPos1.l_an_nr;

     --Alles auf fakturiert im Lieferschein setzen macht belzeil_trigger
     UPDATE belegpos SET belp_menge_done = belp_menge, belp_erledigt = true WHERE TBeleg.GetDokumentNrFromPos(belp_id) =lifschdokunr;

     --in Belegkopf die Daten (Anschreiben und Schlußtext) aus Lieferschein eintragen
     PERFORM disablemodified();
     UPDATE belkopf SET     be_bem1=lifschPos1.beld_kopftext,
                            be_bem2=lifschpos1.beld_fusstext,
                            be_bem1_rtf=lifschPos1.beld_kopftext_rtf,
                            be_bem2_rtf=lifschpos1.beld_fusstext_rtf
            WHERE be_bnr=bebnr AND be_bem1 IS NULL AND be_bem2 IS NULL;
     PERFORM enablemodified();

     RETURN;
    END $$ LANGUAGE plpgsql;

--



--Holt zu einer Rechnung die zugehörigen Anzahlungsrechnungen
--Verwendung bei LOLL List und Label-Rechnung
CREATE OR REPLACE FUNCTION tfaktura.abschlagszahl(IN bebnr VARCHAR, IN abschlnr INTEGER, OUT abebnr VARCHAR, OUT bebdat DATE, OUT begesamtnet NUMERIC, OUT begesamtsteu NUMERIC, OUT stkzahl NUMERIC, OUT stkpreis NUMERIC) RETURNS RECORD AS $$
    DECLARE i INTEGER;
            r record;
            debi VARCHAR(30);
            prof VARCHAR(5);
    BEGIN
     I:=1;
     --
     SELECT be_rkrz, be_prof INTO debi, prof FROM belkopf WHERE be_bnr=bebnr;
     IF prof='T' THEN
            RETURN;
     END IF;
     --
     FOR r IN
            SELECT
             be_bnr,
             be_bdat,
             be_gesamt_net,
             be_gesamt_steu,
             be_zahl_erledigt,
             bz_fakt,
             bz_vkp
            FROM
             belkopf JOIN belzeil_grund ON bz_be_bnr=be_bnr
            WHERE
             be_prof='T'
            AND
             belzeil_add_auftg_pos(bz_auftg,bz_auftgpos) IN (SELECT belzeil_add_auftg_pos(bz_auftg,bz_auftgpos) FROM belzeil_grund WHERE bz_be_bnr=bebnr)
            AND
             be_rkrz=debi
            ORDER BY be_bnr DESC
     LOOP
            --
            IF i=abschlnr THEN
                    abebnr:=r.be_bnr;
                    bebdat:=r.be_bdat;
                    begesamtnet:=r.be_gesamt_net;
                    begesamtsteu:=r.be_gesamt_steu;
                    stkzahl:=r.bz_fakt;
                    stkpreis:=r.bz_vkp;
            END IF;
            i:=i+1;
     END LOOP;
     --
     RETURN;
    END $$ LANGUAGE plpgsql STABLE;


CREATE OR REPLACE FUNCTION tfaktura.letzte_rechnung_dat(aknr VARCHAR, mid INTEGER, dat DATE) RETURNS NUMERIC(16,2) AS $$
    BEGIN
     RETURN tartikel.me__menge__in__menge_uf1(mid, bz_tot/Do1If0(bz_fakt))  FROM belzeil_grund JOIN belkopf ON bz_be_bnr=be_bnr WHERE bz_aknr=aknr AND be_bdat<=dat AND bz_fakt>0 ORDER BY be_bdat DESC LIMIT 1;
    END $$ LANGUAGE plpgsql STABLE;
--

-- Ermittelt den Wert der Teilrechnungen (Anzahlungen, Abschläge) zu einer Auftragsposition
  -- Verwendung: Vororder LOLL
  -- Wenn der Auftrag richtig verrechnet wurde, ist ag_stkf gesetzt
  -- Bei Anzahlungs- & Abschlagsrechnung ist ag_stkf 0, daher müssen die beiden Rechnungsformen hier separat behandelt werden.
  -- Berücksichtigung von Anzahlungen abhängig vom Setting chkOhneAbschlagRechnung (siehe #10675).
-- alt: tfaktura.getabrechbetrag(IN agnr VARCHAR, IN agpos INTEGER, OUT wert_basis_w NUMERIC(12,4))
CREATE OR REPLACE FUNCTION tfaktura.belzeil_grund__teilrechnung__pos_wert__basis_w_netto(IN agnr VARCHAR, IN agpos INTEGER, OUT abschlag_wert_basis_w_netto NUMERIC, OUT anzahlung_wert_basis_w_netto NUMERIC) AS $$
  BEGIN
    SELECT
      COALESCE(SUM(CASE WHEN     is_abschlag THEN pos_wert__basis_w_netto END), 0)::NUMERIC(16,4) AS abschlag,
      COALESCE(SUM(CASE WHEN NOT is_abschlag THEN pos_wert__basis_w_netto END), 0)::NUMERIC(16,4) AS anzahlung
    INTO abschlag_wert_basis_w_netto, anzahlung_wert_basis_w_netto
    FROM (
        SELECT
          be_txba = 7 AS is_abschlag,
          SUM(belzeil_pos_wert_calc(bz_id, NULL, true, false)) AS pos_wert__basis_w_netto
        FROM belzeil_grund
          JOIN belkopf ON be_bnr = bz_be_bnr
        WHERE bz_auftg = agnr
          AND bz_auftgpos = agpos
          AND (be_prof = 'T' OR be_txba = 7) -- txba 7 = Abschlagsrechnung (umsatzwirksam)
        GROUP BY is_abschlag
    ) AS sub;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE STRICT;
--

-- #8911 Buchungskonto aus Tabelle 'erloes_zf'
CREATE OR REPLACE FUNCTION Tfaktura.erloes_zf__buchkonto(
      _steu_z       INTEGER,
      _sachkonto    VARCHAR,

      OUT steukonto VARCHAR,
      OUT buchkonto VARCHAR
  ) RETURNS RECORD AS $$
  BEGIN
    -- Umschlüsselung der Konten mittels Konten-Zusammenfassung
    SELECT
      ezf_buchkonto,
      ezf_steukonto
    FROM erloes_zf
    WHERE ezf_steu_z    = _steu_z
      AND ezf_sachkonto = _sachkonto
    INTO
      buchkonto,
      steukonto
    ;

    -- Fallback des Buchungskontos auf Sachkonto (Erlöskonto)
    IF buchkonto IS NULL THEN
        buchkonto := _sachkonto;
    END IF;

    -- Fallback des Steuerkontos auf Steuerkonto
    IF steukonto IS NULL THEN
        -- Bei nicht in Prodat geführten Steuerkonten kann Ergebnis NULL sein.
        -- Anwendungsfall Rechnungsexport: Steuerkonto ist NULL, dort wird also nur der Steuerschlüssel übergeben.
        steukonto := steu_konto FROM steutxt WHERE steu_z = _steu_z;
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Ausgangsrechnung: Einzelne gruppierte Werte der horizontalen Berechnung von Steuerbeträge. #12202
-- Gruppierung nach Steuercode und Steuersatz.
CREATE OR REPLACE FUNCTION Tfaktura.belkopf__horizontal_tax_values(
    IN _invoice_number      VARCHAR,
    -- Default: Belege/Dokumente. Berechnung wird nicht Gruppiert. Export Buchhaltung : Berechnung wird Gruppiert (von fibu__export aus gesteuert)
    IN group_by_konto       BOOLEAN = False,
    IN group_by_ks          BOOLEAN = False,
    IN group_by_an_nr       BOOLEAN = False,
    OUT netto       NUMERIC(12,2),
    OUT brutto      NUMERIC(12,2),
    OUT steubetrag  NUMERIC(12,2),
    OUT steucode    INTEGER,
    OUT steuproz    NUMERIC(5,2),
    -- Steuerkonto  für die Buchhaltung - Herkunft steutxt über Steuerschlüssel -> auftg.ag_steucode -> belkopf.be_steucode1
    OUT steukonto   VARCHAR(20),
    -- Erlöskonto   für die Buchhaltung - Herkunft: artcod | art -> auftg.ag_konto -> belzeil.bz_zeko.
    -- Ein Steuerkonto kann mehrere Buchungskonten / Sachkonten enthalten (1:n)
    OUT konto       VARCHAR(20),
    OUT ks          VARCHAR(20),
    OUT an_nr       VARCHAR(30),
    OUT automatik   BOOLEAN
  ) RETURNS SETOF RECORD AS $$
  DECLARE pos_ids         INTEGER[];
          beleg_optionen  RECORD;
  BEGIN
    -- Alle Wert-relevanten Auftragspositionen sammeln.
    -- Diese gelten auch für die AbZu.
    pos_ids :=
        array_agg(p_id)
      FROM TWawi.rechnung_posext
        JOIN belzeil_grund AS bzg ON bz_id = p_id
      WHERE p_dokunr = _invoice_number
        AND ( -- Das muss analoger Aufruf per Funktion werden wie auftg_get_auftgmainpos IS NULL (Aufruf in sum_auftg_dokunr bzw. auftg_dokument__horizontal_tax_values).
          NOT bz_vkptotalpos
          OR NOT EXISTS(
            SELECT true FROM belzeil_grund AS bzg_unterpos -- Preis enthält Unterposition nur dann 0, wenn auch Unterposition, sonst einbeziehen.
            WHERE bzg_unterpos.bz_be_bnr    = bzg.bz_be_bnr
              AND bzg_unterpos.bz_auftg     = bzg.bz_auftg
              AND bzg_unterpos.bz_auftghpos = bzg.bz_auftgpos
          )
        )
    ;

    IF pos_ids IS NULL THEN   RETURN;   END IF; -- kein Datensatz, dann raus mit NULLs.

    -- Optionen laut Belegkopf (Rundung, Anzahlung)
    SELECT
      TSystem.Settings__GetBool('belzeil_rund') AS is_to_round, -- Pos ggf. schon runden.
      be_rund,      -- Rundungsvorschrift (0.01 Cent, 0.05 Rappen)
      be_abprozent  -- Anzahlungssatz
    INTO beleg_optionen
    FROM belkopf WHERE be_bnr = _invoice_number;

    -- Achtung! Horizontale Berechnung der Steuer. #12202
      -- Summen mit Gruppierung pro Steuersatz (aus Pos und AbZu).
      -- Summierte Netto-Werte runden.
      -- Auf gerundetete Netto-Werte Steuer anwenden und Brutto erneut runden.
    FOR netto, brutto, steubetrag, steucode, steukonto, steuproz, konto, ks, an_nr, automatik IN
        SELECT
          p_sum_netto,
          p_sum_brutto,
          p_sum_brutto - p_sum_netto AS p_sum_steuerbetrag,
          p_scode,
          p_steukonto,
          p_sproz,
          -- Optionen
          p_konto_out,
          p_ks_out,
          p_an_nr_out,
          er_automatik_out

        -- Brutto-Summen, gruppiert nach Steuersätzen, gerundet
        FROM (
          SELECT
            p_sum_netto,

            num_round_by_precision_rule(
              ( p_sum_netto                           -- Netto, gruppiert nach Steuersätzen, gerundet
                * (1 + COALESCE(p_sproz, 0) / 100)    -- mal Steuersatz (Brutto)
              ),
              COALESCE(beleg_optionen.be_rund, 0.01)  -- Abschließende Rundung auf Cent oder Rappen. Unabh. vom Setting: vgl. bel_gesamt_steu.
            )
            AS p_sum_brutto, -- Brutto, gruppiert nach Steuersätzen, gerundet

            p_scode,
            p_steukonto,
            p_sproz,
            -- Optionen
            p_konto_out,
            p_ks_out,
            p_an_nr_out,
            er_automatik_out

          -- Netto-Summen, gruppiert nach Steuersätzen, gerundet
          FROM (
            SELECT
              num_round_by_precision_rule(
                ( SUM(
                    CASE WHEN beleg_optionen.is_to_round THEN -- Pos-Werte und Abzu-Werte werden entspr. Setting vorher gerundet: vgl. belzeil_grund__b_iu und belabzu__b_iu.
                          num_round_by_precision_rule(p_wert_netto, beleg_optionen.be_rund)
                    ELSE  p_wert_netto
                    END
                  )
                  * COALESCE(beleg_optionen.be_abprozent / 100, 1) -- Anzahlungssatz
                ),
                COALESCE(beleg_optionen.be_rund, 0.01)  -- Abschließende Rundung auf Cent oder Rappen. Unabh. vom Setting: vgl. bel_gesamt_betrag.
              ) AS p_sum_netto, -- gemeinsame Summe (Pos und Abzu) netto, gruppiert nach Steuersätzen, gerundet

              p_scode,
              p_steukonto,
              p_sproz,
              -- Optionen
              CASE WHEN group_by_konto      THEN p_konto    ELSE NULL END::VARCHAR  AS p_konto_out,     -- umgeschlüsselte Erlös-/Buchungskonten berücksichtigt, siehe #9694 (COALESCE auf p_konto bereits in Funktion).
              CASE WHEN group_by_ks         THEN p_ks       ELSE NULL END::VARCHAR  AS p_ks_out,
              CASE WHEN group_by_an_nr      THEN p_an_nr    ELSE NULL END::VARCHAR  AS p_an_nr_out,
              er_automatik AS er_automatik_out

            -- Pos und AbZu-Werte einzeln
            FROM (
              SELECT -- PosWerte mit jeweiligem Steuersatz
                (bz_ep_netto * p_menge)                     AS p_wert_netto, -- Netto-Wert ohne AbZu vgl. bel_gesamt_betrag. Inkl. Rabatte vgl. belzeil_grund__b_iu.
                p_scode                                     AS p_scode,
                er_kto                                      AS p_steukonto,
                p_sproz,
                -- Optionen
                (TFaktura.erloes_zf__buchkonto(p_scode, p_konto)).buchkonto AS p_konto,
                p_ks,
                p_an_nr,
                er_automatik
              FROM TWawi.rechnung_posext
                JOIN belzeil_grund  ON bz_id = p_id
                LEFT JOIN erloes    ON er_kto = (TFaktura.erloes_zf__buchkonto(p_scode, p_konto)).steukonto -- Automatik-Konto laut Erlöskonto (bz_zeko)
              WHERE p_id = ANY(pos_ids)

              UNION ALL -- Pos-AbZu-Werte mit jeweiligem Steuersatz
              SELECT
                (COALESCE(az_betrag, 0) * az_anzahl)        AS p_wert_netto,
                az_scode                                    AS p_scode,
                er_kto                                      AS p_steukonto,
                az_sproz                                    AS p_sproz,
                -- Optionen
                (TFaktura.erloes_zf__buchkonto(az_scode, COALESCE(az_konto, rp.p_konto))).buchkonto AS p_konto, -- Erlöskonte folgt ggf. der RechnungsPos
                p_ks,
                p_an_nr, -- AbZu folgt Pos
                er_automatik
              FROM TWawi.rechnung_posext AS rp
                JOIN TWawi.BelKopf_Abzu ON az_parent_id = rp.p_dokunr AND beaz_belpos = rp.p_pos -- AbZu an RechnungsPos
                LEFT JOIN erloes        ON er_kto = (TFaktura.erloes_zf__buchkonto(az_scode, COALESCE(az_konto, rp.p_konto))).steukonto  -- Automatik-Konto laut Erlöskonto
              WHERE rp.p_id = ANY(pos_ids)

              UNION ALL -- Beleg-AbZu-Werte mit jeweiligem Steuersatz
              SELECT
                (COALESCE(az_betrag, 0) * az_anzahl)        AS p_wert_netto,
                az_scode                                    AS p_scode,
                er_kto                                      AS p_steukonto,
                az_sproz                                    AS p_sproz,
                -- Optionen
                (TFaktura.erloes_zf__buchkonto(az_scode, COALESCE(az_konto, first_rp.p_konto))).buchkonto AS p_konto, -- Erlöskonte folgt ggf. der ersten RechnungsPos
                NULL AS p_ks,
                NULL AS p_an_nr, -- unbekannt bei Beleg-AbZu
                er_automatik
              FROM TWawi.BelKopf_Abzu
                LEFT JOIN LATERAL (SELECT p_konto FROM TWawi.rechnung_posext WHERE p_id = ANY(pos_ids) AND p_konto IS NOT NULL ORDER BY p_pos LIMIT 1) AS first_rp ON true
                LEFT JOIN erloes        ON er_kto = (TFaktura.erloes_zf__buchkonto(az_scode, COALESCE(az_konto, first_rp.p_konto))).steukonto   -- Automatik-Konto laut Erlöskonto
              WHERE az_parent_id = _invoice_number
                AND beaz_belpos IS NULL
            ) AS pos_abzu_werte

            GROUP BY p_scode, p_sproz, p_steukonto, p_konto_out, p_ks_out, p_an_nr_out, er_automatik_out
          ) AS netto_summen

        ) AS brutto_summen
        WHERE p_sum_netto <> 0 -- Keine 0 Zeilen (Artikel 111, Titel-Zeilen ohne Wert und damit ohne Kontierug)
        ORDER BY p_sum_steuerbetrag DESC, p_sproz DESC, p_scode
    LOOP
        netto       := COALESCE(netto,      0);
        brutto      := COALESCE(brutto,     0);
        steubetrag  := COALESCE(steubetrag, 0);
        -- steucode bleibt ggf. NULL, wenn nicht angegeben.
        steuproz    := COALESCE(steuproz,   0);

        RETURN NEXT;
    END LOOP;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Datenaufbereitung für Rechnungsexporte (DATEV, SIMBA)
CREATE OR REPLACE FUNCTION Tfaktura.fibu__export__data_preparation(
    IN in_be_bnr            VARCHAR DEFAULT NULL,
    IN group_by_konto       BOOLEAN DEFAULT True,
    IN group_by_ks          BOOLEAN DEFAULT false,
    IN group_by_an_nr       BOOLEAN DEFAULT false
  )
  RETURNS TABLE(
    be_prof                 VARCHAR,  -- (1)
    be_bnr                  VARCHAR,  -- (15)
    be_titel                VARCHAR,  -- (175)
    ad_krz                  VARCHAR,  -- (21)
    a1_knr                  INTEGER,
    be_rkrz                 VARCHAR,  -- (25)
    be_bdat                 DATE,
    be_fallig               DATE,
    be_waco                 VARCHAR,  -- (3)
    be_umr                  NUMERIC,  -- (8,2)
    steu_z                  VARCHAR,  -- (20)
    steu_konto              VARCHAR,  -- (20)
    bz_ks                   VARCHAR,  -- (9)
    bz_zeko                 VARCHAR,  -- (12)
    bz_an_nr                VARCHAR,  -- (50)
    ad_landiso              VARCHAR,  -- (5)
    ad_ustidnr              VARCHAR,  -- (20)
    ad_such                 VARCHAR,  -- (75)
    er_automatik            BOOLEAN,
    -- Summen
    be_gesamt_steu          NUMERIC,  -- (12,2)
    be_gesamt_steu_basis_w  NUMERIC   -- (12,2)
  ) AS $$
  DECLARE bk_rec RECORD;
  BEGIN
    FOR bk_rec IN -- alle relevanten Rechnungen, Kopfdaten
        SELECT
          bk.d_typ, bk.d_dokunr, bk.d_titel, bk.d_ad_krz, COALESCE(adk1.a1_desk, bk.d_adkrz_nr::VARCHAR) AS d_adkrz_nr, bk.d_adkrz, bk.d_insert_date, bk.d_datum_soll,
          bk.d_we, belkopf.be_umr, adk.ad_landiso, adk.ad_ustidnr, adk.ad_such
        FROM TWawi.rechnung_belegext  AS bk
          JOIN belkopf                      ON belkopf.be_bnr = bk.d_dokunr
          LEFT JOIN adk1                    ON adk1.a1_krz = bk.d_ad_krz -- ist bereits adk_ad_krz durch View
          LEFT JOIN adk                     ON adk.ad_krz  = bk.d_ad_krz
        WHERE bk.d_typ IN ('R', 'G', 'T')
          AND bk.d_def
          AND CASE WHEN nullif(in_be_bnr, '') IS NOT NULL THEN
                  bk.d_dokunr = in_be_bnr
              ELSE
                  bk.d_datum_fibu_buchung IS NULL AND bk.d_insert_date >= current_date - 356
              END
        ORDER BY bk.d_insert_date, bk.d_dokunr
    LOOP
        FOR -- FUNCTION OUTs
          -- Kopfdaten
          be_prof, be_bnr, be_titel, ad_krz, a1_knr, be_rkrz, be_bdat, be_fallig,
          be_waco, be_umr, ad_landiso, ad_ustidnr, ad_such,
          -- Steuerdaten
          steu_z, steu_konto,
          -- Optionen für Gruppierung
          bz_zeko, bz_ks, bz_an_nr, er_automatik,
          -- Summen (Brutto)
          be_gesamt_steu,
          be_gesamt_steu_basis_w
        IN
            SELECT
              -- Kopfdaten
              bk_rec.d_typ, bk_rec.d_dokunr, bk_rec.d_titel, bk_rec.d_ad_krz, bk_rec.d_adkrz_nr, bk_rec.d_adkrz, bk_rec.d_insert_date, bk_rec.d_datum_soll,
              bk_rec.d_we, bk_rec.be_umr, bk_rec.ad_landiso, bk_rec.ad_ustidnr, bk_rec.ad_such,
              -- Steuerdaten
              htv.steucode, htv.steukonto,
              -- Optionen für Gruppierung
              htv.konto, htv.ks, htv.an_nr, htv.automatik,
              -- Summen (Brutto)
              htv.brutto,                 -- be_gesamt_steu
              htv.brutto * bk_rec.be_umr  -- be_gesamt_steu_basis_w
            FROM (
              SELECT
                steucode, steukonto, steuproz,  -- Steuerdaten
                konto, ks, an_nr, automatik,        -- Optionen
                netto, brutto, steubetrag           -- Summen
              FROM TFaktura.belkopf__horizontal_tax_values(
                bk_rec.d_dokunr,
                group_by_konto,
                group_by_ks,
                group_by_an_nr
              )
            ) AS htv
            ORDER BY bk_rec.d_insert_date, bk_rec.d_dokunr, htv.konto, htv.brutto DESC, htv.steuproz DESC, htv.steucode DESC
        LOOP
            RETURN NEXT;
        END LOOP;
    END LOOP;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

 -- Einzahlschein

 ---ACHTUNG : Es ist jeweils nur ein OUT gültig, da es unterschiedliche Prüfstrings für Prüfziffer 1 und 2 gibt
 --  Prüfziffer 1 : SELECT (belkopf__esr_verification_no(:pruefstr)).check1
 --  Prüfziffer 2 : SELECT (belkopf__esr_verification_no(:pruefstr)).check2
 -- Neu durch #11081 ersetzt TRIGGER belkopf__esr_nr
 -- Diese Funktion kann Anfang 2023 nach deprecated verschoben werden
CREATE OR REPLACE FUNCTION belkopf__esr_verification_no(IN _pruefstr VARCHAR, OUT check1 INTEGER, OUT check2 INTEGER) RETURNS RECORD AS $$
  DECLARE ESR VARCHAR[];
          pruefstr VARCHAR;
          prueftstr INTEGER;
          uebertr INTEGER;
          I Integer;
  BEGIN
    --Einzahlschein Nummer berechnen
    ESR[01]:= '0946827135';
    ESR[02]:= '9468271350';
    ESR[03]:= '4682713509';
    ESR[04]:= '6827135094';
    ESR[05]:= '8271350946';
    ESR[06]:= '2713509468';
    ESR[07]:= '7135094682';
    ESR[08]:= '1350946827';
    ESR[09]:= '3509468271';
    ESR[10]:= '5094682713';
    --
    -- Berechnung Prüfziffer 1
    IF LENGTH(_pruefstr) > 13 THEN  --Prüfziffer ESR Referenz hat 26 Stellen
     pruefstr:=_pruefstr;
     uebertr:=0;
     IF LENGTH(_pruefstr) <> 26 THEN
      RAISE EXCEPTION 'Prüfziffer kann nicht gebildet werden. Die Rechnungsnummer entspricht nicht den Konventionen.';
     END IF; -- Fehlermeldung, da eigentlich nur die Rechnungsnummer zur Abweichung führen kann und visuell nicht auffällt, ob die Nummer 26 oder 27 Stellen hat
     --
     FOR i IN 1..26 LOOP
        prueftstr:=CAST(SubStr(pruefstr, i, 1) AS INTEGER);--wir durchlaufen alle Stellen des Pruefstrings und bilden aus jeder eine Prüfsumme
        uebertr:=CAST(SubStr(ESR[uebertr+1], prueftstr+1, 1) AS INTEGER);--Pruefnummer erzeugen
     END LOOP;
     --
     IF uebertr=0 THEN
        check1:=0;
     ELSE
        check1:=10-uebertr;
     END IF;
    END IF;

   --Berechnung Prüfziffer 2 : Die Prüfziffer der Kodierzeile wird über die ersten 12 Stellen gebildet
   IF LENGTH(_pruefstr) < 13  THEN
    pruefstr:=_pruefstr;
    uebertr:=0;
    IF LENGTH(_pruefstr) <> 12 THEN
      RAISE EXCEPTION 'Prüfziffer kann nicht gebildet werden. Die Kodierzeile entspricht nicht den Konventionen.';
     END IF;
    --
    FOR i IN 1..12 LOOP
        prueftstr:=CAST(SubStr(pruefstr, i, 1) AS INTEGER);--wir durchlaufen alle Stellen des Pruefstrings und bilden aus jeder eine Prüfsumme
        uebertr:=CAST(SubStr(ESR[uebertr+1], prueftstr+1, 1) AS INTEGER);--Pruefnummer erzeugen
    END LOOP;
    --
    IF uebertr=0 THEN
        check2:=0;
    ELSE
        check2:=10-uebertr;
    END IF;
   END IF;
   --
   RETURN;
  END $$ LANGUAGE plpgsql;


--

-- Prüfziffer Swiss QR-Referenz berechnen per Modulo 10 rekursiv Verfahren
CREATE OR REPLACE FUNCTION tfaktura.belkopf__verification_swissqr_qrr( _pruefstr VARCHAR ) RETURNS INTEGER AS $$
  DECLARE ESR VARCHAR[];
          pruefstr VARCHAR;
          pruefint INTEGER;
          uebertr INTEGER;
          prfziffer INTEGER;
          i INTEGER;
  BEGIN

    ESR[01]:= '0946827135';
    ESR[02]:= '9468271350';
    ESR[03]:= '4682713509';
    ESR[04]:= '6827135094';
    ESR[05]:= '8271350946';
    ESR[06]:= '2713509468';
    ESR[07]:= '7135094682';
    ESR[08]:= '1350946827';
    ESR[09]:= '3509468271';
    ESR[10]:= '5094682713';
    --
    pruefstr:=_pruefstr;
    uebertr:=0;

    --Prüfzeichenkette QR-Referenz hat genau 26 Stellen
    IF LENGTH(_pruefstr) <> 26 THEN
      RAISE EXCEPTION 'Prüfziffer kann nicht gebildet werden. Es wird eine 26-stellige Nummer erwartet.';
    END IF;

    --Prüfung auf numerische Rechnungsnummer. Nur diese sind erlaubt.
    IF NOT IsNumeric(pruefstr) THEN
      RAISE EXCEPTION 'Prüfziffer kann nicht gebildet werden. Die Rechnungsnummer muss numerisch sein.';
    END IF;

    FOR i IN 1..26 LOOP
      pruefint:=CAST(SubStr(pruefstr, i, 1) AS INTEGER);--wir durchlaufen alle Stellen des Pruefstrings und bilden aus jeder eine Prüfsumme
      uebertr:=CAST(SubStr(ESR[uebertr+1], pruefint+1, 1) AS INTEGER);--Prüfnummer erzeugen
    END LOOP;

    IF uebertr=0 THEN
      prfziffer:=0;
    ELSE
      prfziffer:=10-uebertr;
    END IF;
    --
    RETURN prfziffer;
  END $$ LANGUAGE plpgsql;


-- Prüfziffer Swiss QR SCOR-Referenz berechnen per Modulo 97-10 Verfahren
CREATE OR REPLACE FUNCTION tfaktura.belkopf__verification_swissqr_scor( _pruefstr VARCHAR ) RETURNS VARCHAR AS $$
  DECLARE pruefstr  VARCHAR;
          pruefint  INTEGER;
          prfziffer VARCHAR;
  BEGIN
    -- Die Prüfziffer wird über die Zeichenkette Rechnungsnummer+Kundennummer be_bnr::VARCHAR||lpad(a1_knr,8,0)::VARCHAR gebildet
    IF LENGTH(_pruefstr||'RFPZ') > 25 THEN  --RF ~fix, PZ ist Platzhalter für Prüfziffer
      RAISE EXCEPTION 'Prüfziffer kann nicht gebildet werden. Die Structured Creditor Reference darf maximal 25 Zeichen haben.';
    END IF;
    -- Laut Spezifikation kann die Prüfziffer der SCOR Referenz auch über alfanumerische Zeichen gebildet
    -- diese müssten aber umgerechnet werden; kann also bei Bedarf in die Funktion aufgenommen werden
    IF NOT IsNumeric(_pruefstr) THEN
        RAISE EXCEPTION 'Prüfziffer kann nicht gebildet werden. Die Rechnungsnummer muss numerisch sein.';
    END IF;

    pruefstr := _pruefstr||'271500'; --RF~2715 Konvertierung der Buchstaben zur Stelle im Alphabet+9; unbekannte Prüfziffer fix 00 >> 271500
    -- Bildung der Prüfziffer im Modulo 97-10 Verfahren
    pruefint := 98-(mod(pruefstr::numeric,97));

    IF pruefint < 10 THEN
      prfziffer := '0'||pruefint::VARCHAR;
    ELSE
      prfziffer := pruefint::VARCHAR;
    END IF;
    --
    RETURN prfziffer;

  END $$ LANGUAGE plpgsql;


-- Ausprägung und Referenz für Swiss QR-Code #18432
-- der Algorithmus in Worten im Wiki https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Zahlschein_(Einzahlungsschein) Abschnitt Ausprägungs
-- Es wird keine Exception bei fehlerhaften Eingaben gegeben, sondern INVALID als Rückgabe, CI Test prüft auf INVALID
CREATE OR REPLACE FUNCTION tfaktura.belkopf__swissqr__spec(
  _be_bnr VARCHAR,       -- Rechnungsnummer
  _a1_knr INTEGER,       -- Kundennummer, wird für Rechnungsadresse be_rkrz erwartet
  _qr_iban VARCHAR,      -- entspricht kto_qr_iban
  _ad_landiso VARCHAR,   -- Land des Kunden
  _be_waco VARCHAR,      -- Währung der Rechnung
  OUT spec VARCHAR,      -- spec kurz specification ~ entspricht Ausprägung
  OUT reference VARCHAR  -- Referenz inklusive Prüfziffer
  ) RETURNS RECORD AS $$
  DECLARE qr_iban_trim VARCHAR;
          scor_setting BOOLEAN;
          refstr VARCHAR;
  BEGIN
    scor_setting := TSystem.Settings__GetBool('BELKOPF__SWISSQR_SCOR'); -- SCOR Verfahren aktiv?

    -- der Trim-Wert wird für spätere Erweiterung der Funktion benötigt und soll als Out-param übergeben werden
    IF _qr_iban IS NOT NULL THEN
      qr_iban_trim := trim(replace(_qr_iban,' ',''));
    ELSE
      qr_iban_trim := null;
    END IF;

    spec := 'INVALID';

    IF qr_iban_trim IS NULL
       OR ( qr_iban_trim IS NOT NULL
            AND (_ad_landiso <> 'CH') AND (_ad_landiso <> 'LI')
            AND NOT scor_setting
          )
       THEN
         spec := 'NON';
    END IF;

    IF qr_iban_trim IS NOT NULL
       AND ( (_ad_landiso = 'CH') OR (_ad_landiso = 'LI') )
       THEN
         spec := 'QR';
    END IF;

    IF qr_iban_trim IS NOT NULL
       AND (_ad_landiso <> 'CH') AND (_ad_landiso <> 'LI')
       AND scor_setting
       AND ( _be_waco = 'EUR' OR _be_waco = 'CHF' )
       THEN
         spec := 'SCOR';
    END IF;

    IF spec = 'NON' THEN
      reference:= '';
    END IF;

    IF spec = 'QR' THEN
      refstr := trim(lpad(trim(lpad(replace(_be_bnr,' ',''),12,'0'))::varchar||trim(lpad(replace(_a1_knr,' ',''),8,'0'))::varchar,26,'0')::varchar)::varchar; --das könnte man in einer späteren Version mit eigener Funktion kapseln
      IF IsNumeric(refstr)
         AND LENGTH(_be_bnr) <= 12
         AND LENGTH(_a1_knr) <= 8 -- default theoretisch durch Setting debi_bis abgesichert
      THEN
        reference:= refstr||tfaktura.belkopf__verification_swissqr_qrr(refstr);
      ELSE
        reference:='INVALID'; -- (invoice no. not numeric or longer 12 chars)
        -- belkopf__verification_swissqr_qrr würde exception bei nichtnumerisch werfen
      END IF;
    END IF;

    IF spec = 'SCOR' THEN
      refstr := (_be_bnr::varchar||lpad(_a1_knr,8,0)::varchar)::varchar;
      IF IsNumeric(refstr) THEN
        reference:= 'RF'||tfaktura.belkopf__verification_swissqr_scor(refstr)||refstr;  --RF+Prüfziffer+max21chars
      ELSE
        reference:='INVALID';
      END IF;
    END IF;
    --
    RETURN;

  END $$ LANGUAGE plpgsql;
